#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
using gov.va.med.vbecs.DAL.HL7.OpenLibrary;
using gov.va.med.vbecs.DAL.HL7.OpenLibrary.Messages;
#endregion


namespace gov.va.med.vbecs.DAL.HL7AL.UnitTests
{
	[TestFixture]
	public class HL7AL_HL7MessageLog : BaseTest
	{
		private const string TAS_TEST_ORDER = "1^TAS^99VBC^^";
		private const string KC_DIVISION = "589^VA HEARTLAND - WEST, VISN 15";
		private static HL7Interface _intParms;
		private static string _hl7Message;
		private static DataTable _dtMessage;

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();
			_intParms = new HL7Interface("CPRS");
			int orderNum = HL7ALUnitTestUtility.GetRandomNumber(9999);
			int orderGroupNum = orderNum + 1;
			_hl7Message = HL7ALUnitTestUtility.GetCprsMessage("NW",orderNum.ToString(),orderGroupNum.ToString(),TAS_TEST_ORDER,KC_DIVISION,HL7ALUnitTestUtility.GetRandomNumber(999999).ToString());
			_dtMessage = HL7MessageLog.GetMessageDataForMessageLogInsert(_hl7Message,COMMON.MessageStatus.ProcessingIncomingMessage,_intParms,COMMON.UpdateFunction.HL7CprsInterface);

		}

		[TearDown]
		protected void TearDown()
		{
		}

		[Test]
		public void InsertMessageLog_Pass()
		{
			Assert.IsTrue(HL7MessageLog.InsertMessageLog(_dtMessage) == 0);

		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void InsertMessageLog_Fail()
		{
			HL7MessageLog.InsertMessageLog(null);
		}

		[Test]
		public void UpdateMessageStatus_Pass()
		{
			string msgControlId = null;
			foreach( DataRow dr in _dtMessage.Rows )
			{
				if( dr.IsNull(Common.VbecsTables.MessageLog.MessageControlId.ToString()))
					Assert.Fail("Failed to identify MessageControlId");
				else
				{
					msgControlId = dr[Common.VbecsTables.MessageLog.MessageControlId].ToString();
					break;
				}
			}
			HL7MessageLog.InsertMessageLog(_dtMessage);
			Assert.IsNotNull(msgControlId);
			Assert.IsTrue(HL7MessageLog.UpdateMessageStatus(COMMON.MessageStatus.SuccessfullyCompleted,msgControlId,null,0,"Unit Test",COMMON.UpdateFunction.HL7CprsInterface)== 0);
			DataRow drRes = UnitTestUtil.RunSQLGetDataRow("SELECT * FROM MessageLog WHERE MessageControlId = '" + msgControlId + "'");
			Assert.IsTrue(Convert.ToInt32(drRes[Common.VbecsTables.MessageLog.MessageStatusCode]) == 3);

		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void UpdateMessageStatus_Fail()
		{
			string msgControlId = null;
			foreach( DataRow dr in _dtMessage.Rows )
			{
				if( dr.IsNull(Common.VbecsTables.MessageLog.MessageControlId.ToString()))
					Assert.Fail("Failed to identify MessageControlId");
				else
				{
					msgControlId = dr[Common.VbecsTables.MessageLog.MessageControlId].ToString();
					break;
				}
			}
			HL7MessageLog.InsertMessageLog(_dtMessage);
			HL7MessageLog.UpdateMessageStatus(COMMON.MessageStatus.SuccessfullyCompleted,null,null,0,"Unit Test",COMMON.UpdateFunction.HL7CprsInterface);

		}

		[Test]
		public void InsertAckMessageControlId_Pass()
		{
			string msgControlId = null;
			foreach( DataRow dr in _dtMessage.Rows )
			{
				if( dr.IsNull(Common.VbecsTables.MessageLog.MessageControlId.ToString()))
					Assert.Fail("Failed to identify MessageControlId");
				else
				{
					msgControlId = dr[Common.VbecsTables.MessageLog.MessageControlId].ToString();
					break;
				}
			}
			//Insert the original message.
			HL7MessageLog.InsertMessageLog(_dtMessage);
			HL7OmgMessage omgMsg = new HL7OmgMessage(_hl7Message);
			//Create the Acknowledgement message.
			HL7OrgMessage ackMessage = CprsOrgMessage.AppAcceptAck( omgMsg, OrderControlCodes.OK, HL7ALUnitTestUtility.GetRandomNumber(99999) );
			//Insert the ackMessage
			DataTable dtAck = HL7MessageLog.GetMessageDataForMessageLogInsert(ackMessage.Message,COMMON.MessageStatus.SuccessfullyCompleted,_intParms,COMMON.UpdateFunction.HL7CprsInterface);
			//Insert the ackMessageControlId for the original message
			Assert.IsTrue(HL7MessageLog.InsertAckMessageControlId(msgControlId,ackMessage.MessageControlID,COMMON.MessageStatus.SuccessfullyCompleted,"Unit Test",COMMON.UpdateFunction.HL7CprsInterface) == 0);
		}

		[Test]
		public void InsertAckMessageControlId_Fail()
		{
			string msgControlId = null;
			foreach( DataRow dr in _dtMessage.Rows )
			{
				if( dr.IsNull(Common.VbecsTables.MessageLog.MessageControlId.ToString()))
					Assert.Fail("Failed to identify MessageControlId");
				else
				{
					msgControlId = dr[Common.VbecsTables.MessageLog.MessageControlId].ToString();
					break;
				}
			}
			//Insert the original message.
			HL7MessageLog.InsertMessageLog(_dtMessage);
			HL7OmgMessage omgMsg = new HL7OmgMessage(_hl7Message);

			//Create the Acknowledgement message.
			HL7OrgMessage ackMessage = CprsOrgMessage.AppAcceptAck( omgMsg, OrderControlCodes.OK, HL7ALUnitTestUtility.GetRandomNumber(99999) );
			//Insert the ackMessage
			DataTable dtAck = HL7MessageLog.GetMessageDataForMessageLogInsert(ackMessage.Message,COMMON.MessageStatus.SuccessfullyCompleted,_intParms,COMMON.UpdateFunction.HL7CprsInterface);
			//Attempt to insert the ackMessageControlId for a message where the message control ID is 0.
			Assert.IsTrue(HL7MessageLog.InsertAckMessageControlId("0",ackMessage.MessageControlID,COMMON.MessageStatus.SuccessfullyCompleted,"Unit Test",COMMON.UpdateFunction.HL7CprsInterface) != 0);

		}

		[Test]
		public void GetMessageDataForMessageLogInsert_Pass()
		{
			Assert.IsNotNull(HL7MessageLog.GetMessageDataForMessageLogInsert(_hl7Message,COMMON.MessageStatus.ProcessingIncomingMessage,_intParms,COMMON.UpdateFunction.HL7CprsInterface));
		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void GetMessageDataForMessageLogInsert_Fail()
		{
			HL7MessageLog.GetMessageDataForMessageLogInsert(null,COMMON.MessageStatus.ProcessingIncomingMessage,_intParms,COMMON.UpdateFunction.HL7CprsInterface);
		}

		[Test]
		public void PurgeMessageLog_Pass()
		{
			int messageAgeForSuccessfulPurgeInDays = Convert.ToInt32(UnitTestUtil.RunSQLGetDataRow("SELECT MAX(PurgeSuccessfulMessage) AS Days FROM InterfaceControl")["Days"]);
			//
			// Just to be safe
			messageAgeForSuccessfulPurgeInDays += 1;
			//
			string updateQuery = "UPDATE MessageLog SET MessageStatusCode = 3, LastUpdateDate = DATEADD(DAY, -" + messageAgeForSuccessfulPurgeInDays + ", GETUTCDATE()) WHERE MessageLogId = (SELECT MAX(MessageLogId) FROM MessageLog)";
			UnitTestUtil.RunSQLGetDataRowDontThrowExceptionIfNoRowIsReturned(updateQuery);
			//
			int count = HL7MessageLog.PurgeMessageLog();
			Assert.IsTrue(count > 0, "No Message Log entries to purge!");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void PurgeMessageLog_Fail()
		{
		}
	}
}
#endif
